<?php
/**
 * Background Pattern Style - Waves.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Waves
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Waves extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Waves', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M33.77,0C25.09,3.81,14.57,6.5,0,6.5V0ZM200,6.5V0H166.23C174.91,3.81,185.43,6.5,200,6.5ZM133.77,0H100c24,0,35.79,7.64,48.23,15.73a125,125,0,0,0,18,10.27H200c-24,0-35.79-7.64-48.23-15.73A125,125,0,0,0,133.77,0ZM100,0H66.23a125,125,0,0,0-18,10.27C35.79,18.36,24,26,0,26H33.77a125,125,0,0,0,18-10.27C64.21,7.64,76,0,100,0ZM66.23,26h67.54c-8.68-3.81-19.2-6.5-33.77-6.5S74.91,22.19,66.23,26Z"/>',
				'default-inverted' => '<path d="M200,6.5V26c-24,0-35.79-7.64-48.23-15.73A125,125,0,0,0,133.77,0h32.46C174.91,3.81,185.43,6.5,200,6.5ZM100,0C76,0,64.21,7.64,51.77,15.73A125,125,0,0,1,33.77,26H66.23c8.68-3.81,19.2-6.5,33.77-6.5s25.09,2.69,33.77,6.5h32.46a125,125,0,0,1-18-10.27C135.79,7.64,124,0,100,0ZM66.23,0H33.77C25.09,3.81,14.57,6.5,0,6.5V26c24,0,35.79-7.64,48.23-15.73A125,125,0,0,1,66.23,0Z"/>',
				'rotated'          => '<path d="M0,166.23c3.81,8.68,6.5,19.2,6.5,33.77H0ZM6.5,0H0V33.77C3.81,25.09,6.5,14.57,6.5,0ZM0,66.23V100C0,76,7.64,64.21,15.73,51.77A125,125,0,0,0,26,33.77V0c0,24-7.64,35.79-15.73,48.23A125,125,0,0,0,0,66.23ZM0,100v33.77a125,125,0,0,0,10.27,18C18.36,164.21,26,176,26,200V166.23a125,125,0,0,0-10.27-18C7.64,135.79,0,124,0,100Zm26,33.77V66.23c-3.81,8.68-6.5,19.2-6.5,33.77S22.19,125.09,26,133.77Z"/>',
				'rotated-inverted' => '<path d="M6.5,0H26c0,24-7.64,35.79-15.73,48.23A125,125,0,0,0,0,66.23V33.77C3.81,25.09,6.5,14.57,6.5,0ZM0,100c0,24,7.64,35.79,15.73,48.23a125,125,0,0,1,10.27,18V133.77c-3.81-8.68-6.5-19.2-6.5-33.77S22.19,74.91,26,66.23V33.77a125,125,0,0,1-10.27,18C7.64,64.21,0,76,0,100Zm0,33.77v32.46c3.81,8.68,6.5,19.2,6.5,33.77H26c0-24-7.64-35.79-15.73-48.23A125,125,0,0,1,0,133.77Z"/>',
				'thumbnail'        => '<path d="M5.63,0A13.46,13.46,0,0,1,0,1.08V0Zm3,2.62a12.83,12.83,0,0,1,8-2.62H11A21.4,21.4,0,0,0,8,1.71,12.8,12.8,0,0,1,0,4.33V5.41A13.46,13.46,0,0,0,5.63,4.33,20.72,20.72,0,0,0,8.62,2.62ZM38.94,0H27.69a13.46,13.46,0,0,0,5.63,1.08A13.41,13.41,0,0,0,38.94,0ZM27.69,4.33a13.46,13.46,0,0,0,5.63,1.08,13.41,13.41,0,0,0,5.62-1.08,21.4,21.4,0,0,0,3-1.71A12.81,12.81,0,0,1,50,0H44.35a21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71H16.66a12.8,12.8,0,0,1,8,2.62A21.4,21.4,0,0,0,27.69,4.33ZM72.26,0H61a13.41,13.41,0,0,0,5.62,1.08A13.43,13.43,0,0,0,72.26,0Zm5.41,0a21.4,21.4,0,0,0-3,1.71,12.81,12.81,0,0,1-8,2.62,12.8,12.8,0,0,1-8-2.62A21.4,21.4,0,0,0,55.6,0H50a12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.41,13.41,0,0,0,5.62,1.08,13.43,13.43,0,0,0,5.63-1.08,21.4,21.4,0,0,0,3-1.71A14.39,14.39,0,0,1,80,.37V0Zm-3,6a12.81,12.81,0,0,1-8,2.62A12.8,12.8,0,0,1,58.6,6a21.4,21.4,0,0,0-3-1.71A13.57,13.57,0,0,0,50,3.25a13.62,13.62,0,0,0-5.63,1.08,21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,4.33,21.4,21.4,0,0,0,8,6,12.8,12.8,0,0,1,0,8.66V9.75A13.45,13.45,0,0,0,5.63,8.66,19.82,19.82,0,0,0,8.62,7a12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,20.45,20.45,0,0,0,3,1.71,13.45,13.45,0,0,0,5.63,1.09,13.4,13.4,0,0,0,5.62-1.09,20.45,20.45,0,0,0,3-1.71,12.81,12.81,0,0,1,8-2.62A12.8,12.8,0,0,1,58,7a20.45,20.45,0,0,0,3,1.71,13.4,13.4,0,0,0,5.62,1.09,13.42,13.42,0,0,0,5.63-1.09,20.45,20.45,0,0,0,3-1.71A14.39,14.39,0,0,1,80,4.7V3.58a12.5,12.5,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,6Zm0,4.33a12.81,12.81,0,0,1-8,2.62,12.8,12.8,0,0,1-8-2.62,21.4,21.4,0,0,0-3-1.71A13.57,13.57,0,0,0,50,7.58a13.62,13.62,0,0,0-5.63,1.08,21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,8.66a21.4,21.4,0,0,0-3,1.71A12.8,12.8,0,0,1,0,13v1.09A13.45,13.45,0,0,0,5.63,13a19,19,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,19.58,19.58,0,0,0,3,1.71,13.45,13.45,0,0,0,5.63,1.09A13.4,13.4,0,0,0,38.94,13a19.58,19.58,0,0,0,3-1.71,12.81,12.81,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62A19.58,19.58,0,0,0,61,13a13.4,13.4,0,0,0,5.62,1.09A13.42,13.42,0,0,0,72.26,13a19.58,19.58,0,0,0,3-1.71A14.39,14.39,0,0,1,80,9V7.91a12.5,12.5,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,10.37Zm0,4.34a13.63,13.63,0,0,1-16.07,0,20.47,20.47,0,0,0-3-1.72A13.57,13.57,0,0,0,50,11.91,13.62,13.62,0,0,0,44.35,13a20.47,20.47,0,0,0-3,1.72,12.86,12.86,0,0,1-8,2.62,12.89,12.89,0,0,1-8-2.62,20,20,0,0,0-3-1.72,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,13a20.47,20.47,0,0,0-3,1.72,12.86,12.86,0,0,1-8,2.62v1.08a13.62,13.62,0,0,0,5.63-1.08,19.85,19.85,0,0,0,3-1.72,12.89,12.89,0,0,1,8-2.62,12.86,12.86,0,0,1,8,2.62,20.47,20.47,0,0,0,3,1.72,13.62,13.62,0,0,0,5.63,1.08,13.57,13.57,0,0,0,5.62-1.08,20.47,20.47,0,0,0,3-1.72A12.87,12.87,0,0,1,50,13a12.86,12.86,0,0,1,8,2.62,20.47,20.47,0,0,0,3,1.72,15.19,15.19,0,0,0,11.25,0,20.47,20.47,0,0,0,3-1.72A14.39,14.39,0,0,1,80,13.36V12.24a12.5,12.5,0,0,0-2.33.75A20.47,20.47,0,0,0,74.67,14.71Zm0,4.33A13.63,13.63,0,0,1,58.6,19a19.58,19.58,0,0,0-3-1.71A13.4,13.4,0,0,0,50,16.24a13.45,13.45,0,0,0-5.63,1.09,19.58,19.58,0,0,0-3,1.71,12.86,12.86,0,0,1-8,2.62,12.89,12.89,0,0,1-8-2.62,19.11,19.11,0,0,0-3-1.71,13.37,13.37,0,0,0-5.62-1.09A13.45,13.45,0,0,0,11,17.33,19.58,19.58,0,0,0,8,19a12.86,12.86,0,0,1-8,2.62v1.08a13.62,13.62,0,0,0,5.63-1.08,19.85,19.85,0,0,0,3-1.72,12.89,12.89,0,0,1,8-2.61,12.86,12.86,0,0,1,8,2.61,20.47,20.47,0,0,0,3,1.72,13.62,13.62,0,0,0,5.63,1.08,13.57,13.57,0,0,0,5.62-1.08,20.47,20.47,0,0,0,3-1.72,12.87,12.87,0,0,1,8-2.61,12.86,12.86,0,0,1,8,2.61,20.47,20.47,0,0,0,3,1.72,15.19,15.19,0,0,0,11.25,0,20.47,20.47,0,0,0,3-1.72A14.39,14.39,0,0,1,80,17.69V16.57a11.8,11.8,0,0,0-2.33.76A19.58,19.58,0,0,0,74.67,19Zm0,4.33a13.63,13.63,0,0,1-16.07,0,20.45,20.45,0,0,0-3-1.71A13.4,13.4,0,0,0,50,20.57a13.45,13.45,0,0,0-5.63,1.09,20.45,20.45,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,19.94,19.94,0,0,0-3-1.71,13.37,13.37,0,0,0-5.62-1.09A13.45,13.45,0,0,0,11,21.66a20.45,20.45,0,0,0-3,1.71A12.8,12.8,0,0,1,0,26v1.08A13.62,13.62,0,0,0,5.63,26a20.72,20.72,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.62,13.62,0,0,0,5.63,1.08A13.57,13.57,0,0,0,38.94,26a21.4,21.4,0,0,0,3-1.71,12.81,12.81,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62A21.4,21.4,0,0,0,61,26a15.19,15.19,0,0,0,11.25,0,21.4,21.4,0,0,0,3-1.71A14.4,14.4,0,0,1,80,22V20.9a11.8,11.8,0,0,0-2.33.76A20.45,20.45,0,0,0,74.67,23.37Zm0,4.33a13.63,13.63,0,0,1-16.07,0,20.45,20.45,0,0,0-3-1.71A13.4,13.4,0,0,0,50,24.9,13.45,13.45,0,0,0,44.35,26a20.45,20.45,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,19.94,19.94,0,0,0-3-1.71,13.37,13.37,0,0,0-5.62-1.09A13.45,13.45,0,0,0,11,26,20.45,20.45,0,0,0,8,27.7a12.8,12.8,0,0,1-8,2.62V31.4a13.62,13.62,0,0,0,5.63-1.08,20.72,20.72,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.62,13.62,0,0,0,5.63,1.08,13.57,13.57,0,0,0,5.62-1.08,21.4,21.4,0,0,0,3-1.71A12.81,12.81,0,0,1,50,26a12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,15.19,15.19,0,0,0,11.25,0,21.4,21.4,0,0,0,3-1.71A14.4,14.4,0,0,1,80,26.35V25.23a11.8,11.8,0,0,0-2.33.76A20.45,20.45,0,0,0,74.67,27.7Zm0,4.33A13.63,13.63,0,0,1,58.6,32a21.4,21.4,0,0,0-3-1.71A13.41,13.41,0,0,0,50,29.24a13.46,13.46,0,0,0-5.63,1.08,21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.38,13.38,0,0,0-5.62-1.08A13.46,13.46,0,0,0,11,30.32,21.4,21.4,0,0,0,8,32a12.8,12.8,0,0,1-8,2.62v1.08a13.46,13.46,0,0,0,5.63-1.08,20.72,20.72,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.46,13.46,0,0,0,5.63,1.08,13.41,13.41,0,0,0,5.62-1.08,21.4,21.4,0,0,0,3-1.71,12.81,12.81,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.41,13.41,0,0,0,5.62,1.08,13.43,13.43,0,0,0,5.63-1.08,21.4,21.4,0,0,0,3-1.71A14.39,14.39,0,0,1,80,30.69V29.57a11.8,11.8,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,32Zm0,4.33a13.63,13.63,0,0,1-16.07,0,21.4,21.4,0,0,0-3-1.71A13.41,13.41,0,0,0,50,33.57a13.46,13.46,0,0,0-5.63,1.08,21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.38,13.38,0,0,0-5.62-1.08A13.46,13.46,0,0,0,11,34.65a21.4,21.4,0,0,0-3,1.71A12.8,12.8,0,0,1,0,39v1.08A13.46,13.46,0,0,0,5.63,39a20.72,20.72,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,21.4,21.4,0,0,0,3,1.71,13.46,13.46,0,0,0,5.63,1.08A13.41,13.41,0,0,0,38.94,39a21.4,21.4,0,0,0,3-1.71,12.81,12.81,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62A21.4,21.4,0,0,0,61,39a13.41,13.41,0,0,0,5.62,1.08A13.43,13.43,0,0,0,72.26,39a21.4,21.4,0,0,0,3-1.71A14.39,14.39,0,0,1,80,35V33.9a12.5,12.5,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,36.36Zm0,4.33a13.63,13.63,0,0,1-16.07,0,21.4,21.4,0,0,0-3-1.71A13.57,13.57,0,0,0,50,37.9,13.62,13.62,0,0,0,44.35,39a21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,39a21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62V44.4a13.45,13.45,0,0,0,5.63-1.09,19.82,19.82,0,0,0,3-1.71,12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62,20.45,20.45,0,0,0,3,1.71,13.45,13.45,0,0,0,5.63,1.09,13.4,13.4,0,0,0,5.62-1.09,20.45,20.45,0,0,0,3-1.71A12.81,12.81,0,0,1,50,39a12.8,12.8,0,0,1,8,2.62,20.45,20.45,0,0,0,3,1.71,15.06,15.06,0,0,0,11.25,0,20.45,20.45,0,0,0,3-1.71A14.39,14.39,0,0,1,80,39.35V38.23a12.5,12.5,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,40.69Zm0,4.33A13.63,13.63,0,0,1,58.6,45a21.4,21.4,0,0,0-3-1.71A13.57,13.57,0,0,0,50,42.23a13.62,13.62,0,0,0-5.63,1.08,21.4,21.4,0,0,0-3,1.71,12.8,12.8,0,0,1-8,2.62,12.83,12.83,0,0,1-8-2.62,20.84,20.84,0,0,0-3-1.71,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,43.31,21.4,21.4,0,0,0,8,45a12.8,12.8,0,0,1-8,2.62v1.09a13.45,13.45,0,0,0,5.63-1.09,19,19,0,0,0,3-1.71,12.89,12.89,0,0,1,8-2.62,12.86,12.86,0,0,1,8,2.62,19.58,19.58,0,0,0,3,1.71,13.45,13.45,0,0,0,5.63,1.09,13.4,13.4,0,0,0,5.62-1.09,19.58,19.58,0,0,0,3-1.71,12.87,12.87,0,0,1,8-2.62,12.86,12.86,0,0,1,8,2.62,19.58,19.58,0,0,0,3,1.71,15.06,15.06,0,0,0,11.25,0,19.58,19.58,0,0,0,3-1.71A14.39,14.39,0,0,1,80,43.68V42.56a12.5,12.5,0,0,0-2.33.75A21.4,21.4,0,0,0,74.67,45Zm0,4.34a13.63,13.63,0,0,1-16.07,0,20.47,20.47,0,0,0-3-1.72A13.57,13.57,0,0,0,50,46.56a13.62,13.62,0,0,0-5.63,1.08,20.47,20.47,0,0,0-3,1.72,12.86,12.86,0,0,1-8,2.62,12.89,12.89,0,0,1-8-2.62,20,20,0,0,0-3-1.72,13.54,13.54,0,0,0-5.62-1.08A13.62,13.62,0,0,0,11,47.64a20.47,20.47,0,0,0-3,1.72A12.86,12.86,0,0,1,0,52v1.08A13.62,13.62,0,0,0,5.63,52a19.85,19.85,0,0,0,3-1.72,12.89,12.89,0,0,1,8-2.62,12.86,12.86,0,0,1,8,2.62,20.47,20.47,0,0,0,3,1.72,13.62,13.62,0,0,0,5.63,1.08A13.57,13.57,0,0,0,38.94,52a20.47,20.47,0,0,0,3-1.72,12.87,12.87,0,0,1,8-2.62,12.86,12.86,0,0,1,8,2.62A20.47,20.47,0,0,0,61,52a15.19,15.19,0,0,0,11.25,0,20.47,20.47,0,0,0,3-1.72A14.39,14.39,0,0,1,80,48V46.89a12.5,12.5,0,0,0-2.33.75A20.47,20.47,0,0,0,74.67,49.36Zm0,4.33a13.63,13.63,0,0,1-16.07,0,19.58,19.58,0,0,0-3-1.71A13.4,13.4,0,0,0,50,50.89,13.45,13.45,0,0,0,44.35,52a19.58,19.58,0,0,0-3,1.71,12.86,12.86,0,0,1-8,2.62,12.89,12.89,0,0,1-8-2.62,19.11,19.11,0,0,0-3-1.71,13.37,13.37,0,0,0-5.62-1.09A13.45,13.45,0,0,0,11,52a19.58,19.58,0,0,0-3,1.71,12.86,12.86,0,0,1-8,2.62v1.08a13.62,13.62,0,0,0,5.63-1.08,19.85,19.85,0,0,0,3-1.72,12.89,12.89,0,0,1,8-2.61,12.86,12.86,0,0,1,8,2.61,20.47,20.47,0,0,0,3,1.72,13.62,13.62,0,0,0,5.63,1.08,13.57,13.57,0,0,0,5.62-1.08,20.47,20.47,0,0,0,3-1.72A12.87,12.87,0,0,1,50,52a12.86,12.86,0,0,1,8,2.61,20.47,20.47,0,0,0,3,1.72,15.19,15.19,0,0,0,11.25,0,20.47,20.47,0,0,0,3-1.72A14.39,14.39,0,0,1,80,52.34V51.22a11.8,11.8,0,0,0-2.33.76A19.58,19.58,0,0,0,74.67,53.69Zm0,4.33a16.36,16.36,0,0,1-3.79,2h2.64c.61-.34,1.18-.71,1.74-1.07A14.4,14.4,0,0,1,80,56.67V55.55a11.8,11.8,0,0,0-2.33.76A20.45,20.45,0,0,0,74.67,58ZM58.6,58a20.45,20.45,0,0,0-3-1.71A13.4,13.4,0,0,0,50,55.22a13.45,13.45,0,0,0-5.63,1.09,20.45,20.45,0,0,0-3,1.71,16.16,16.16,0,0,1-3.79,2H40.2c.61-.34,1.18-.71,1.74-1.07a12.81,12.81,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62c.56.36,1.13.73,1.74,1.07h2.64A16.36,16.36,0,0,1,58.6,58ZM25.28,58a19.94,19.94,0,0,0-3-1.71,13.37,13.37,0,0,0-5.62-1.09A13.45,13.45,0,0,0,11,56.31,20.45,20.45,0,0,0,8,58a16.16,16.16,0,0,1-3.79,2H6.88c.61-.34,1.18-.71,1.74-1.07a12.83,12.83,0,0,1,8-2.62,12.8,12.8,0,0,1,8,2.62c.56.36,1.14.73,1.75,1.07h2.63A16.36,16.36,0,0,1,25.28,58Z"/>',
			),
			'width'      => '200px',
			'height'     => '26px',
		);
	}
}

return new ET_Builder_Pattern_Waves();
