<?php
/**
 * Background Pattern Style - Honeycomb.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Honeycomb
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Honeycomb extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Honeycomb', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M41.12,40,53,16.28,60.62,1H80V0H58.88L40,37.76,21.12,0H0V1H19.38L27,16.28,38.88,40,19.38,79H0v2H19.38l19.5,39-19.5,39H0v1H21.12L40,122.24,58.88,160H80v-1H60.62l-19.5-39,19.5-39H80V79H60.62ZM40,117.76,21.12,80,40,42.24,58.88,80Z"/>',
				'default-inverted' => '<path d="M21.12,0H58.88L40,37.76ZM38.88,40,27,16.28,19.38,1H0V79H19.38ZM21.12,80,40,117.76,58.88,80,40,42.24Zm17.76,40L19.38,81H0v78H19.38ZM60.62,1,53,16.28,41.12,40l19.5,39H80V1ZM41.12,120l19.5,39H80V81H60.62ZM40,122.24,21.12,160H58.88Z"/>',
				'rotated'          => '<path d="M40,38.88,16.28,27,1,19.38V0H0V21.12L37.76,40,0,58.88V80H1V60.62L16.28,53,40,41.12l39,19.5V80h2V60.62l39-19.5,39,19.5V80h1V58.88L122.24,40,160,21.12V0h-1V19.38l-39,19.5L81,19.38V0H79V19.38ZM117.76,40,80,58.88,42.24,40,80,21.12Z"/>',
				'rotated-inverted' => '<path d="M0,58.88V21.12L37.76,40ZM40,41.12,16.28,53,1,60.62V80H79V60.62ZM80,58.88,117.76,40,80,21.12,42.24,40Zm40-17.76L81,60.62V80h78V60.62ZM1,19.38,16.28,27,40,38.88l39-19.5V0H1Zm119,19.5,39-19.5V0H81V19.38ZM122.24,40,160,58.88V21.12Z"/>',
				'thumbnail'        => '<path d="M73.54.38H80V0H73L66.67,14.16,60.37,0H46.29L40,14.16,33.71,0H19.63l-6.3,14.16L7,0H0V.38H6.46L9,6.11,13,15,6.46,29.62H0v.76H6.46L13,45,6.46,59.62H0V60H7l6.29-14.16L19.63,60H33.71L40,45.84,46.29,60H60.37l6.3-14.16L73,60h7v-.38H73.54L67,45l6.5-14.62H80v-.76H73.54L67,15,71,6.11ZM44.33,6.11,46.87.38H59.79l2.55,5.73,4,8.89-6.5,14.62H46.87L40.37,15Zm-26.67,0L20.21.38H33.13l2.54,5.73,4,8.89-6.5,14.62H20.21L13.71,15ZM7,30l6.29-14.16L19.63,30l-6.3,14.16ZM33.13,59.62H20.21L13.71,45l6.5-14.62H33.13L39.63,45ZM33.71,30,40,15.84,46.29,30,40,44.16ZM59.79,59.62H46.87L40.37,45l6.5-14.62H59.79L66.29,45ZM73,30,66.67,44.16,60.37,30l6.3-14.16Z"/>',
			),
			'width'      => '80px',
			'height'     => '160px',
		);
	}
}

return new ET_Builder_Pattern_Honeycomb();
